<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/Core/Autoloader.php';
App\Core\Autoloader::register();

use App\Config\Config;
use App\Core\DB;
use App\Services\SefazService;

Config::init();
DB::init();

$rows = DB::pdo()->query("SELECT i.tenant_id, i.chave, t.cnpj FROM invoices i JOIN tenants t ON t.id = i.tenant_id WHERE i.status = 'baixado' AND t.status = 'ativo'")->fetchAll();
foreach ($rows as $r) {
    SefazService::manifestar((int)$r['tenant_id'], $r['cnpj'], $r['chave'], 'ciencia');
    $up = DB::pdo()->prepare("UPDATE invoices SET status = 'ciencia', updated_at = ? WHERE tenant_id = ? AND chave = ?");
    $up->execute([date('Y-m-d H:i:s'), (int)$r['tenant_id'], $r['chave']]);
}
