<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Diagnóstico do Certificado</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<div class="card mx-auto" style="max-width:720px">
<div class="card-body">
<h2 class="card-title mb-3">Diagnóstico do Certificado A1</h2>
<p>Empresa: <strong><?= htmlspecialchars($tenant['name'] ?? '') ?></strong></p>
<p>CNPJ: <strong><?= htmlspecialchars($tenant['cnpj'] ?? '') ?></strong></p>
<p>UF/Ambiente: <strong><?= htmlspecialchars($tenant['uf'] ?? '') ?></strong> / <strong><?= htmlspecialchars($tenant['ambiente'] ?? '') ?></strong></p>
<hr>
<p>Arquivo do certificado: <strong><?= htmlspecialchars($path) ?></strong></p>
<?php if (!$isPfx): ?>
<p class="text-warning">Aviso: o caminho informado não termina com .pfx. O certificado A1 deve ser um arquivo .pfx.</p>
<p>Caminho esperado: <strong><?= htmlspecialchars($expectedPath) ?></strong></p>
<?php endif; ?>
<p>Arquivo existe? 
  <?php if ($exists): ?>
    <span class="badge bg-success">Sim</span>
  <?php else: ?>
    <span class="badge bg-danger">Não</span>
  <?php endif; ?>
</p>
<p>Senha informada (texto puro em banco)? 
  <?php if ($senhaInformada): ?>
    <span class="badge bg-success">Sim</span>
  <?php else: ?>
    <span class="badge bg-secondary">Não</span>
  <?php endif; ?>
</p>
<p>Senha decriptada (via cert_password_enc)? 
  <?php if ($senhaDec): ?>
    <span class="badge bg-success">OK</span>
  <?php else: ?>
    <span class="badge bg-warning text-dark">Vazia</span>
  <?php endif; ?>
</p>
<p>Leitura do PFX com a senha: 
  <?php if ($canRead): ?>
    <span class="badge bg-success">Sucesso</span>
  <?php else: ?>
    <span class="badge bg-danger">Falha</span>
  <?php endif; ?>
</p>
<?php if (!$canRead && !empty($errMsg)): ?>
<div class="alert alert-danger">Erro ao ler PFX: <?= htmlspecialchars($errMsg) ?></div>
<?php endif; ?>
<?php if (!$canRead && empty($errMsg)): ?>
<div class="alert alert-warning">Não foi possível validar o PFX. Verifique se o arquivo é .pfx e a senha está correta.</div>
<?php endif; ?>
<div class="mt-3 d-flex gap-2">
  <a href="/tenant" class="btn btn-primary">Voltar para Empresa</a>
  <a href="/tenant/check-cert" class="btn btn-secondary">Testar novamente</a>
  <a href="/dashboard" class="btn btn-outline-secondary">Dashboard</a>
  <a href="/sefaz/teste" class="btn btn-outline-primary">Testar acesso SEFAZ</a>
</div>
</div>
</div>
</div>
</body>
</html>
