<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Status do Plano</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:Arial;padding:20px;background:#f6f7fb}
.card{max-width:720px;margin:0 auto;background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 8px rgba(0,0,0,.08)}
table{width:100%;border-collapse:collapse}
th,td{padding:8px;border-bottom:1px solid #eee;text-align:left}
</style>
</head>
<body>
<div class="card">
<h2>Status do Plano</h2>
<p>Status do tenant: <?= htmlspecialchars($info['status'] ?? '') ?></p>
<p>Plano: <?= htmlspecialchars($info['name'] ?? '') ?>, limite mensal: <?= (int)($info['limit_notas'] ?? 0) ?></p>
<h3>Pagamentos recentes</h3>
<table>
<thead><tr><th>Status</th><th>Valor</th><th>Data</th></tr></thead>
<tbody>
<?php foreach ($list as $r): ?>
<tr>
<td><?= htmlspecialchars($r['status']) ?></td>
<td>R$ <?= number_format((float)$r['amount'], 2, ',', '.') ?></td>
<td><?= htmlspecialchars($r['created_at']) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<p><a href="/plano/assinatura">Assinar/renovar</a> | <a href="/dashboard">Voltar</a></p>
</div>
</body>
</html>
