<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Dashboard Empresarial</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<?php $role = $_SESSION['role'] ?? 'empresa'; ?>
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/dashboard">NFe Cloud Manager</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navMain">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/dashboard">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="/painel">Notas</a></li>
      <li class="nav-item"><a class="nav-link" href="/sefaz/consultar">Consultar SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/tenant">Empresa</a></li>
      <li class="nav-item"><a class="nav-link" href="/plano/status">Plano e Pagamentos</a></li>
      <?php if ($role === 'admin'): ?>
      <li class="nav-item"><a class="nav-link" href="/admin/empresas">Admin Empresas</a></li>
      <li class="nav-item"><a class="nav-link" href="/cron/consulta">CRON Consulta</a></li>
      <li class="nav-item"><a class="nav-link" href="/cron/manifestacao/notas">CRON Manifestação</a></li>
      <?php endif; ?>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="text-muted small"><?= htmlspecialchars(strtoupper($role)) ?></span>
      <a class="btn btn-outline-primary btn-sm" href="/perfil">Perfil</a>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
<h2 class="mb-3">Dashboard Empresarial</h2>
<form class="row g-2 align-items-end mb-3" method="get" action="/dashboard">
  <div class="col-auto">
    <label class="form-label">Mês</label>
    <input class="form-control" type="month" name="mes" value="<?= htmlspecialchars($mes) ?>">
  </div>
  <div class="col-auto">
    <button class="btn btn-primary" type="submit">Atualizar</button>
  </div>
</form>
<div class="row g-3">
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="text-muted">Total de notas no mês</div>
        <div class="h4"><?= (int)($resMes['qtde'] ?? 0) ?></div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="text-muted">Total de entradas</div>
        <div class="h4"><?= (int)$entradas ?></div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="text-muted">Total de saídas</div>
        <div class="h4"><?= (int)$saidas ?></div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="text-muted">Valor total</div>
        <div class="h4">R$ <?= number_format((float)($resMes['total'] ?? 0), 2, ',', '.') ?></div>
      </div>
    </div>
  </div>
</div>
<div class="row g-3 mt-1">
  <div class="col-lg-6">
    <div class="card">
      <div class="card-body">
        <div class="text-muted mb-2">Última consulta SEFAZ</div>
        <?php if (!empty($ultima)): ?>
          <p>Data: <strong><?= htmlspecialchars($ultima['created_at']) ?></strong></p>
          <p>Status HTTP: <strong><?= (int)$ultima['status_code'] ?></strong></p>
        <?php else: ?>
          <p class="text-warning">Nenhuma consulta registrada.</p>
        <?php endif; ?>
        <a class="btn btn-sm btn-outline-primary mt-2" href="/sefaz/teste">Testar acesso à SEFAZ</a>
      </div>
    </div>
  </div>
  <div class="col-lg-6">
    <div class="card">
      <div class="card-body">
        <div class="text-muted mb-2">Alertas</div>
        <p>Notas não manifestadas: <strong class="<?= $alertas>0?'text-danger':'' ?>"><?= (int)$alertas ?></strong></p>
        <?php if (!empty($plano)): ?>
          <p>Plano: <strong><?= htmlspecialchars($plano['plano'] ?? '') ?></strong></p>
          <p>Status da empresa: <strong><?= htmlspecialchars($plano['empresa_status'] ?? '') ?></strong></p>
          <p>Limite de notas/mês: <strong><?= (int)($plano['limit_notas'] ?? 0) ?></strong></p>
          <a class="btn btn-outline-primary btn-sm" href="/plano/status">Status do Plano</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<div class="row g-3 mt-1">
  <div class="col-lg-12">
    <div class="card">
      <div class="card-body">
        <div class="text-muted mb-2">Relatórios e Exportações</div>
        <a class="btn btn-sm btn-primary" href="/relatorios/pdf">Relatório PDF</a>
        <a class="btn btn-sm btn-secondary" href="/relatorios/csv">Exportar CSV</a>
        <a class="btn btn-sm btn-outline-secondary" href="/painel">XML por período</a>
      </div>
    </div>
  </div>
</div>
</div>
</body>
</html>
