<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Meu Perfil</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/modern-css-reset/dist/reset.min.css">
<style>
body{font-family:Arial;padding:40px;background:#f6f7fb}
.container{max-width:920px;margin:0 auto;display:flex;gap:24px;align-items:flex-start}
.card{flex:1;background:#fff;padding:24px;border-radius:8px;box-shadow:0 2px 8px rgba(0,0,0,.08)}
h2{margin-bottom:16px}
label{display:block;margin-bottom:6px;color:#333}
input{width:100%;padding:10px;margin-bottom:12px;border:1px solid #ccc;border-radius:6px}
button{padding:10px 16px;background:#16a34a;color:#fff;border:0;border-radius:6px;cursor:pointer}
.btn-secondary{background:#4b5563}
.alert{padding:10px 14px;border-radius:6px;margin-bottom:16px;font-size:14px}
.alert-success{background:#dcfce7;color:#166534}
.alert-danger{background:#fee2e2;color:#b91c1c}
.links{margin-top:12px;font-size:14px}
.links a{color:#2563eb;text-decoration:none}
</style>
</head>
<body>
<div class="container">
<div class="card">
<h2>Dados do perfil</h2>
<?php if (!empty($_GET['ok']) && $_GET['ok'] === '1'): ?>
<div class="alert alert-success">Perfil atualizado com sucesso.</div>
<?php endif; ?>
<?php if (!empty($_GET['err']) && $_GET['err'] === 'email'): ?>
<div class="alert alert-danger">Email já está em uso por outro usuário.</div>
<?php endif; ?>
<form method="post" action="/perfil/salvar">
<label>Nome</label>
<input type="text" name="name" required value="<?= htmlspecialchars($user['name'] ?? '') ?>">
<label>Email</label>
<input type="email" name="email" required value="<?= htmlspecialchars($user['email'] ?? '') ?>">
<button type="submit">Salvar perfil</button>
</form>
<div class="links">
<a href="/dashboard">Voltar para o dashboard</a>
</div>
</div>
<div class="card">
<h2>Alterar senha</h2>
<?php if (!empty($_GET['ok']) && $_GET['ok'] === '2'): ?>
<div class="alert alert-success">Senha alterada com sucesso.</div>
<?php endif; ?>
<?php if (!empty($_GET['err']) && $_GET['err'] === 'senha'): ?>
<div class="alert alert-danger">Senha atual inválida ou nova senha vazia.</div>
<?php endif; ?>
<form method="post" action="/perfil/senha">
<label>Senha atual</label>
<input type="password" name="current_password" required>
<label>Nova senha</label>
<input type="password" name="new_password" required>
<button type="submit" class="btn-primary">Alterar senha</button>
</form>
</div>
</div>
</body>
</html>

