<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Admin - Empresas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-4">
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/admin">Admin Master</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAdmin"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navAdmin">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/admin">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link active" href="/admin/empresas">Empresas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/plans">Planos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/assinaturas">Assinaturas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/pagamentos">Pagamentos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/webhooks">Webhooks</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/sefaz">Logs SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/login">Logs Login</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/admin">Logs Admin</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/erro">Logs Erro</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/usuarios">Usuários</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/config">Configurações</a></li>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="badge bg-primary">Admin</span>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4">Empresas</h1>
        <div>
            <a href="/admin/empresa/nova" class="btn btn-primary">Cadastrar nova empresa</a>
        </div>
    </div>
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>CNPJ</th>
                <th>UF</th>
                <th>Ambiente</th>
                <th>Plano</th>
                <th>Status</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($empresas as $e): ?>
            <tr>
                <td><?= htmlspecialchars((string)$e['id']) ?></td>
                <td><?= htmlspecialchars($e['name'] ?? ($e['razao_social'] ?? '')) ?></td>
                <td><?= htmlspecialchars($e['cnpj'] ?? '') ?></td>
                <td><?= htmlspecialchars($e['uf'] ?? '') ?></td>
                <td><?= htmlspecialchars($e['ambiente'] ?? '') ?></td>
                <td><?= htmlspecialchars($e['plano'] ?? '') ?></td>
                <td><span class="badge bg-<?= ($e['status'] === 'ativo') ? 'success' : 'danger' ?>"><?= htmlspecialchars($e['status'] ?? '') ?></span></td>
                <td class="d-flex gap-2">
                    <form method="post" action="/admin/empresa/status" class="d-inline">
                        <input type="hidden" name="tenant_id" value="<?= htmlspecialchars((string)$e['id']) ?>">
                        <select name="status" class="form-select form-select-sm d-inline w-auto">
                            <option value="ativo" <?= ($e['status'] === 'ativo') ? 'selected' : '' ?>>Ativo</option>
                            <option value="inativo" <?= ($e['status'] === 'inativo') ? 'selected' : '' ?>>Inativo</option>
                            <option value="bloqueado" <?= ($e['status'] === 'bloqueado') ? 'selected' : '' ?>>Bloqueado</option>
                        </select>
                        <button class="btn btn-sm btn-outline-primary">Aplicar</button>
                    </form>
                    <form method="post" action="/admin/empresa/trocar-senha" class="d-inline">
                        <input type="hidden" name="tenant_id" value="<?= htmlspecialchars((string)$e['id']) ?>">
                        <input type="password" name="senha" class="form-control form-control-sm d-inline w-auto" placeholder="Nova senha" required>
                        <button class="btn btn-sm btn-outline-warning">Trocar senha</button>
                    </form>
                    <a class="btn btn-sm btn-outline-secondary" href="/admin/empresa/usuarios?id=<?= htmlspecialchars((string)$e['id']) ?>">Usuários</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
