<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Admin - Usuários da Empresa</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-4">
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/admin">Admin Master</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAdmin"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navAdmin">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/admin">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link active" href="/admin/empresas">Empresas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/usuarios">Usuários</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/plans">Planos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/assinaturas">Assinaturas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/pagamentos">Pagamentos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/webhooks">Webhooks</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/sefaz">Logs SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/login">Logs Login</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/admin">Logs Admin</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/erro">Logs Erro</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/config">Configurações</a></li>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="badge bg-primary">Admin</span>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
    <div class="mb-3">
        <h1 class="h4">Usuários da empresa: <?= htmlspecialchars($tenant['name'] ?? '') ?> (CNPJ <?= htmlspecialchars($tenant['cnpj'] ?? '') ?>)</h1>
        <a class="btn btn-sm btn-outline-secondary" href="/admin/empresas">Voltar</a>
    </div>
    <div class="card mb-3">
        <div class="card-body">
            <form class="row g-2" method="post" action="/admin/empresa/usuario/salvar">
                <input type="hidden" name="tenant_id" value="<?= htmlspecialchars((string)($tenant['id'] ?? 0)) ?>">
                <div class="col-md-3">
                    <input class="form-control" name="name" placeholder="Nome" required>
                </div>
                <div class="col-md-3">
                    <input class="form-control" type="email" name="email" placeholder="Email" required>
                </div>
                <div class="col-md-3">
                    <input class="form-control" type="password" name="password" placeholder="Senha" required>
                </div>
                <div class="col-md-2">
                    <select class="form-select" name="role">
                        <option value="empresa">Empresa</option>
                        <option value="admin">Admin</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <button class="btn btn-primary w-100">Adicionar</button>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Email</th>
                <th>Papel</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($usuarios as $u): ?>
            <tr>
                <td><?= htmlspecialchars((string)$u['id']) ?></td>
                <td><?= htmlspecialchars($u['name'] ?? '') ?></td>
                <td><?= htmlspecialchars($u['email'] ?? '') ?></td>
                <td><span class="badge bg-<?= ($u['role'] === 'admin') ? 'primary' : 'secondary' ?>"><?= htmlspecialchars($u['role'] ?? '') ?></span></td>
                <td class="d-flex gap-2">
                    <form method="post" action="/admin/usuario/role" class="d-inline">
                        <input type="hidden" name="user_id" value="<?= htmlspecialchars((string)$u['id']) ?>">
                        <select name="role" class="form-select form-select-sm d-inline w-auto">
                            <option value="empresa" <?= ($u['role'] === 'empresa') ? 'selected' : '' ?>>Empresa</option>
                            <option value="admin" <?= ($u['role'] === 'admin') ? 'selected' : '' ?>>Admin</option>
                        </select>
                        <button class="btn btn-sm btn-outline-primary">Aplicar</button>
                    </form>
                    <form method="post" action="/admin/empresa/usuario/senha" class="d-inline">
                        <input type="hidden" name="tenant_id" value="<?= htmlspecialchars((string)($tenant['id'] ?? 0)) ?>">
                        <input type="hidden" name="user_id" value="<?= htmlspecialchars((string)$u['id']) ?>">
                        <input type="password" name="senha" class="form-control form-control-sm d-inline w-auto" placeholder="Nova senha" required>
                        <button class="btn btn-sm btn-outline-warning">Trocar senha</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
