<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Admin - Configurações Globais</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/admin">Admin Master</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAdmin"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navAdmin">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/admin">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/empresas">Empresas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/plans">Planos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/assinaturas">Assinaturas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/pagamentos">Pagamentos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/webhooks">Webhooks</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/sefaz">Logs SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/login">Logs Login</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/admin">Logs Admin</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/erro">Logs Erro</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/usuarios">Usuários</a></li>
      <li class="nav-item"><a class="nav-link active" href="/admin/config">Configurações</a></li>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="badge bg-primary">Admin</span>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4">Configurações Globais</h1>
</div>
<form method="post" action="/admin/config/salvar" class="row g-3">
  <div class="col-md-6">
    <label class="form-label">Mercado Pago Access Token</label>
    <input class="form-control" type="text" name="mercadopago_access_token" value="<?= htmlspecialchars($mpToken ?? '') ?>">
  </div>
  <div class="col-md-6">
    <label class="form-label">Mercado Pago Webhook Secret</label>
    <input class="form-control" type="text" name="mercadopago_webhook_secret" value="<?= htmlspecialchars($mpSecret ?? '') ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Ambiente SEFAZ</label>
    <select class="form-select" name="sefaz_ambiente">
      <option value="homologacao" <?= ($sefazAmb==='homologacao')?'selected':'' ?>>Homologação</option>
      <option value="producao" <?= ($sefazAmb==='producao')?'selected':'' ?>>Produção</option>
    </select>
  </div>
  <div class="col-md-4">
    <label class="form-label">SMTP Server</label>
    <input class="form-control" type="text" name="smtp_server" value="<?= htmlspecialchars($smtp ?? '') ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Token API</label>
    <input class="form-control" type="text" name="api_token" value="<?= htmlspecialchars($apiToken ?? '') ?>">
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Salvar</button>
  </div>
</form>
</div>
</body>
</html>
