<?php
declare(strict_types=1);

namespace App\Services;

class XMLService
{
    public static function extractFields(string $xml): array
    {
        $emitente = '';
        $destinatario = '';
        $valor = 0.0;
        $data = '';
        try {
            $obj = @simplexml_load_string($xml);
            if ($obj) {
                $ns = $obj->getNamespaces(true);
                $nfe = $obj;
                if (isset($obj->NFe)) {
                    $nfe = $obj->NFe;
                }
                if (isset($nfe->infNFe)) {
                    $inf = $nfe->infNFe;
                    if (isset($inf->emit->xNome)) {
                        $emitente = (string)$inf->emit->xNome;
                    }
                    if (isset($inf->dest->xNome)) {
                        $destinatario = (string)$inf->dest->xNome;
                    }
                    if (isset($inf->total->ICMSTot->vNF)) {
                        $valor = (float)$inf->total->ICMSTot->vNF;
                    }
                    if (isset($inf->ide->dhEmi)) {
                        $data = (string)$inf->ide->dhEmi;
                    } elseif (isset($inf->ide->dEmi)) {
                        $data = (string)$inf->ide->dEmi . 'T00:00:00';
                    }
                }
            }
        } catch (\Throwable $e) {
        }
        if (!$emitente && preg_match('/<emit>.*?<xNome>([^<]+)<\\/xNome>.*?<\\/emit>/s', $xml, $m)) {
            $emitente = $m[1];
        }
        if (!$destinatario && preg_match('/<dest>.*?<xNome>([^<]+)<\\/xNome>.*?<\\/dest>/s', $xml, $m)) {
            $destinatario = $m[1];
        }
        if (!$valor && preg_match('/<vNF>([0-9\\.,]+)<\\/vNF>/', $xml, $m)) {
            $valor = (float)str_replace(',', '.', $m[1]);
        }
        if (!$data && preg_match('/<dhEmi>([^<]+)<\\/dhEmi>/', $xml, $m)) {
            $data = $m[1];
        }
        return ['emitente' => $emitente, 'destinatario' => $destinatario, 'valor_total' => $valor, 'data_emissao' => $data];
    }
}
