<?php
declare(strict_types=1);

namespace App\Services;

use App\Core\DB;
use App\Config\Config;

class SettingsService
{
    public static function get(string $key, $default = null)
    {
        try {
            $stmt = DB::pdo()->prepare("SELECT svalue FROM settings WHERE skey = ? LIMIT 1");
            $stmt->execute([$key]);
            $row = $stmt->fetch();
            if ($row && isset($row['svalue']) && $row['svalue'] !== '') {
                return $row['svalue'];
            }
        } catch (\Throwable $e) {
        }
        $segments = explode('.', $key);
        return Config::get(implode('.', $segments), $default);
    }
}
