<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Admin Master - Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
</head>
<body class="bg-light">
<div class="container py-4">
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/admin">Admin Master</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAdmin"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navAdmin">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link active" href="/admin">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/empresas">Empresas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/plans">Planos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/assinaturas">Assinaturas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/pagamentos">Pagamentos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/webhooks">Webhooks</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/sefaz">Logs SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/login">Logs Login</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/admin">Logs Admin</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/erro">Logs Erro</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/usuarios">Usuários</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/config">Configurações</a></li>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="badge bg-primary">Admin</span>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
<h2 class="mb-3">Dashboard Geral</h2>
<form class="row g-2 align-items-end mb-3" method="get" action="/admin">
  <div class="col-auto">
    <label class="form-label">Mês</label>
    <input class="form-control" type="month" name="mes" value="<?= htmlspecialchars($mes) ?>">
  </div>
  <div class="col-auto">
    <button class="btn btn-primary" type="submit">Atualizar</button>
  </div>
  <div class="col-auto">
    <a class="btn btn-secondary" href="/dashboard">Painel Empresa</a>
  </div>
</form>
<div class="row g-3">
  <div class="col-sm-6 col-lg-3">
    <div class="card"><div class="card-body">
      <div class="text-muted">Total de empresas</div>
      <div class="h4"><?= (int)$totalEmpresas ?></div>
    </div></div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card"><div class="card-body">
      <div class="text-muted">Empresas ativas</div>
      <div class="h4"><?= (int)$empAtivas ?></div>
    </div></div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card"><div class="card-body">
      <div class="text-muted">Empresas bloqueadas</div>
      <div class="h4"><?= (int)$empBloqueadas ?></div>
    </div></div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card"><div class="card-body">
      <div class="text-muted">Notas baixadas no mês</div>
      <div class="h4"><?= (int)$notasMes ?></div>
    </div></div>
  </div>
</div>
<div class="row g-3 mt-1">
  <div class="col-sm-6 col-lg-3">
    <div class="card"><div class="card-body">
      <div class="text-muted">Faturamento mensal</div>
      <div class="h4">R$ <?= number_format((float)$faturamentoMensal, 2, ',', '.') ?></div>
    </div></div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card"><div class="card-body">
      <div class="text-muted">MRR</div>
      <div class="h4">R$ <?= number_format((float)$mrr, 2, ',', '.') ?></div>
    </div></div>
  </div>
</div>
<div class="row g-3 mt-1">
  <div class="col-lg-6">
    <div class="card"><div class="card-body">
      <div class="text-muted mb-2">Faturamento por mês (6 meses)</div>
      <canvas id="fatChart" height="120"></canvas>
    </div></div>
  </div>
  <div class="col-lg-6">
    <div class="card"><div class="card-body">
      <div class="text-muted mb-2">Notas baixadas por mês (6 meses)</div>
      <canvas id="notasChart" height="120"></canvas>
    </div></div>
  </div>
</div>
</div>
<script>
const fatLabels = <?= json_encode(array_map(fn($r)=>$r['mes'],$serieFat)) ?>;
const fatData = <?= json_encode(array_map(fn($r)=>$r['valor'],$serieFat)) ?>;
new Chart(document.getElementById('fatChart'), {
  type: 'line',
  data: { labels: fatLabels, datasets: [{ label: 'Faturamento (R$)', data: fatData, borderColor: '#2563eb', fill: false }] },
  options: { responsive: true, plugins: { legend: { display: false } } }
});
const notasLabels = <?= json_encode(array_map(fn($r)=>$r['mes'],$serieNotas)) ?>;
const notasData = <?= json_encode(array_map(fn($r)=>$r['qtde'],$serieNotas)) ?>;
new Chart(document.getElementById('notasChart'), {
  type: 'bar',
  data: { labels: notasLabels, datasets: [{ label: 'Notas', data: notasData, backgroundColor: '#16a34a' }] },
  options: { responsive: true, plugins: { legend: { display: false } } }
});
</script>
</body>
</html>
