<?php
declare(strict_types=1);

if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require __DIR__ . '/../vendor/autoload.php';
}
require_once __DIR__ . '/../app/Core/Autoloader.php';
App\Core\Autoloader::register();

use App\Core\Router;
use App\Config\Config;
use App\Core\DB;

Config::init();
DB::init();

$sessPath = __DIR__ . '/../storage/sessions';
if (!is_dir($sessPath)) {
    @mkdir($sessPath, 0777, true);
}
if (is_dir($sessPath)) {
    @session_save_path($sessPath);
}
session_start();

$router = new Router();
require __DIR__ . '/../app/Config/routes.php';
// Ajuste para rodar em subdiretório (ex.: /sisxml)
$script = $_SERVER['SCRIPT_NAME'] ?? '';
$basePath = dirname(dirname($script));
if ($basePath && $basePath !== '/' && strpos($_SERVER['REQUEST_URI'] ?? '/', $basePath) === 0) {
    $newUri = substr($_SERVER['REQUEST_URI'], strlen($basePath));
    $_SERVER['REQUEST_URI'] = $newUri !== '' ? $newUri : '/';
}
$router->dispatch($_SERVER['REQUEST_URI'], $_SERVER['REQUEST_METHOD']);
