<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Configurar Empresa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<h2 class="mb-3">Configurar Empresa</h2>
<?php if (!empty($uploadError)): ?>
<div class="alert alert-danger" role="alert">
<?= htmlspecialchars($uploadError) ?>
</div>
<?php endif; ?>
<?php if (!empty($hasCert) && !empty($tenant['cert_path'])): ?>
<p class="text-success">Certificado atual: configurado em <?= htmlspecialchars($tenant['cert_path']) ?></p>
<?php else: ?>
<p class="text-warning">Nenhum certificado configurado ainda.</p>
<?php endif; ?>
<div class="mb-3">
  <a class="btn btn-outline-primary btn-sm" href="/tenant/check-cert">Diagnosticar certificado</a>
  <a class="btn btn-outline-secondary btn-sm" href="/plano/status">Plano e Pagamentos</a>
</div>
<form method="post" action="/tenant/save" enctype="multipart/form-data" class="mt-3">
<div class="mb-3">
<label class="form-label">Ambiente</label>
<select class="form-select" name="ambiente" required>
    <?php $amb = !empty($tenant['ambiente']) ? $tenant['ambiente'] : 'homologacao'; ?>
    <option value="homologacao" <?= $amb === 'homologacao' ? 'selected' : '' ?>>Homologação</option>
    <option value="producao" <?= $amb === 'producao' ? 'selected' : '' ?>>Produção</option>
</select>
</div>
<div class="mb-3">
<label class="form-label">Plano</label>
<select class="form-select" name="plan_id" required>
<?php foreach ($plans as $p): ?>
<option value="<?= htmlspecialchars($p['id']) ?>"
    <?= isset($tenant['plan_id']) && (int)$tenant['plan_id'] === (int)$p['id'] ? 'selected' : '' ?>>
    <?= htmlspecialchars($p['name']) ?> (limite: <?= htmlspecialchars($p['limit_notas']) ?>)
</option>
<?php endforeach; ?>
</select>
</div>
<div class="mb-3">
<label class="form-label">UF</label>
<select class="form-select" name="uf" required>
<?php foreach (['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'] as $uf): ?>
<option value="<?= $uf ?>" <?= !empty($tenant['uf']) && $tenant['uf'] === $uf ? 'selected' : '' ?>><?= $uf ?></option>
<?php endforeach; ?>
</select>
</div>
<div class="mb-3">
<label class="form-label">Certificado A1 (.pfx)</label>
<input class="form-control" type="file" name="cert_file" accept=".pfx" <?= !empty($hasCert) ? '' : 'required' ?>>
</div>
<div class="mb-3">
<label class="form-label">Senha do certificado</label>
<input class="form-control" type="password" name="cert_password" <?= !empty($hasCert) ? '' : 'required' ?>>
</div>
<button type="submit" class="btn btn-primary">Salvar</button>
</form>
</div>
</body>
</html>
