<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Teste de Acesso SEFAZ</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<div class="card mx-auto" style="max-width:640px">
<div class="card-body">
<h2 class="card-title mb-3">Teste de Comunicação com a SEFAZ</h2>
<p>CNPJ da empresa: <strong><?= htmlspecialchars($cnpj) ?></strong></p>
<?php $ok = !empty($resultado['ok']); ?>
<p>Status do teste: 
  <?php if ($ok): ?>
    <span class="badge bg-success">Sucesso</span>
  <?php else: ?>
    <span class="badge bg-danger">Falha</span>
  <?php endif; ?>
</p>
<p>Código de retorno: <strong><?= (int)($resultado['status'] ?? 0) ?></strong></p>
<p>Mensagem: <strong><?= htmlspecialchars((string)($resultado['mensagem'] ?? '')) ?></strong></p>
<div class="mt-3 d-flex gap-2">
<a href="/dashboard" class="btn btn-primary">Ir para Dashboard</a>
<a href="/sefaz/teste" class="btn btn-secondary">Testar novamente</a>
</div>
</div>
</div>
</div>
</body>
</html>

