<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Resultado da Consulta SEFAZ</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<div class="card mx-auto" style="max-width:640px">
<div class="card-body">
<h2 class="card-title mb-3">Consulta SEFAZ</h2>
<p>CNPJ consultado: <strong><?= htmlspecialchars($cnpj) ?></strong></p>
<p>NSU inicial: <strong><?= htmlspecialchars($nsu) ?></strong></p>
<?php if ($downloaded > 0): ?>
<p class="text-success">Novas NF-e baixadas nesta consulta: <?= (int)$downloaded ?></p>
<?php else: ?>
<p class="text-warning">Nenhuma NF-e nova encontrada nesta consulta.</p>
<?php endif; ?>
<p>Total de NF-e registradas no sistema para esta empresa: <strong><?= (int)$total ?></strong></p>
<?php if (!empty($lastLog)): ?>
<p>Última chamada de distribuição - HTTP status: <strong><?= (int)$lastLog['status_code'] ?></strong> em <?= htmlspecialchars($lastLog['created_at']) ?></p>
<?php else: ?>
<p class="text-warning">Nenhum log de distribuição encontrado para esta empresa.</p>
<?php endif; ?>
<div class="mt-3 d-flex gap-2">
<a href="/dashboard" class="btn btn-primary">Ir para Dashboard</a>
<a href="/sefaz/consultar" class="btn btn-secondary">Consultar novamente</a>
</div>
</div>
</div>
</div>
</body>
</html>
