<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Painel de NF-e Destinadas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<?php $role = $_SESSION['role'] ?? 'empresa'; ?>
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/dashboard">NFe Cloud Manager</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navNotas"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navNotas">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/dashboard">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link active" href="/painel">Notas</a></li>
      <li class="nav-item"><a class="nav-link" href="/sefaz/consultar">Consultar SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/tenant">Empresa</a></li>
      <li class="nav-item"><a class="nav-link" href="/plano/status">Plano e Pagamentos</a></li>
      <?php if ($role === 'admin'): ?>
      <li class="nav-item"><a class="nav-link" href="/admin/empresas">Admin Empresas</a></li>
      <?php endif; ?>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="text-muted small"><?= htmlspecialchars(strtoupper($role)) ?></span>
      <a class="btn btn-outline-primary btn-sm" href="/perfil">Perfil</a>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
<h2 class="mb-3">NF-e Destinadas</h2>
<div class="card mb-3">
<div class="card-body">
<form class="row g-2 align-items-end" method="get" action="/painel">
<div class="col-auto">
<label class="form-label">Mês</label>
<select class="form-select" name="mes" onchange="this.form.submit()">
<?php if (empty($meses)): ?>
<option value="<?= htmlspecialchars($mesAtual) ?>"><?= htmlspecialchars($mesAtual) ?></option>
<?php else: ?>
<?php foreach ($meses as $m): $v = $m['m']; ?>
<option value="<?= htmlspecialchars($v) ?>" <?= $v === $mesAtual ? 'selected' : '' ?>><?= htmlspecialchars($v) ?></option>
<?php endforeach; ?>
<?php endif; ?>
        </select>
        </div>
        <div class="col-auto">
        <button type="submit" class="btn btn-primary">Filtrar</button>
        </div>
        </form>
        <div class="mt-3 d-flex gap-4">
        <div>Total de notas: <strong><?= (int)($resumo['qtde'] ?? 0) ?></strong></div>
        <div>Valor total: <strong>R$ <?= number_format((float)($resumo['total'] ?? 0), 2, ',', '.') ?></strong></div>
        </div>
        </div>
        </div>
        <div class="card">
        <div class="card-body p-0">
        <div class="table-responsive">
        <table class="table table-sm mb-0">
        <thead class="table-light">
<tr>
<th>Data emissão</th>
<th>Número</th>
<th>Chave</th>
<th>Valor</th>
<th>Ações</th>
</tr>
</thead>
<tbody>
<?php if (empty($notas)): ?>
<tr><td colspan="5" class="text-center">Nenhuma NF-e encontrada para o mês selecionado.</td></tr>
<?php else: ?>
<?php foreach ($notas as $n): ?>
<tr>
<td><?= htmlspecialchars($n['data_emissao']) ?></td>
<td><?= htmlspecialchars($n['numero_nota']) ?></td>
<td><?= htmlspecialchars($n['chave_acesso']) ?></td>
<td>R$ <?= number_format((float)$n['valor'], 2, ',', '.') ?></td>
<td>
<a class="btn btn-outline-primary btn-sm" href="/xml/ver?id=<?= (int)$n['id'] ?>">Ver XML</a>
<a class="btn btn-outline-secondary btn-sm" href="/xml/download?id=<?= (int)$n['id'] ?>">Download XML</a>
</td>
</tr>
<?php endforeach; ?>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
</div>
</div>
</body>
</html>
