<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Admin - Plano</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/admin">Admin Master</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAdmin"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navAdmin">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/admin">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/empresas">Empresas</a></li>
      <li class="nav-item"><a class="nav-link active" href="/admin/plans">Planos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/assinaturas">Assinaturas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/pagamentos">Pagamentos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/webhooks">Webhooks</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/sefaz">Logs SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/login">Logs Login</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/admin">Logs Admin</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/erro">Logs Erro</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/config">Configurações</a></li>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
<h1 class="h4 mb-3"><?= !empty($plan) ? 'Editar plano' : 'Novo plano' ?></h1>
<form method="post" action="/admin/plan/save" class="row g-3">
  <input type="hidden" name="id" value="<?= !empty($plan)?(int)$plan['id']:0 ?>">
  <div class="col-md-6">
    <label class="form-label">Nome</label>
    <input class="form-control" type="text" name="name" value="<?= htmlspecialchars($plan['name'] ?? '') ?>" required>
  </div>
  <div class="col-md-3">
    <label class="form-label">Limite de notas/mês</label>
    <input class="form-control" type="number" name="limit_notas" value="<?= htmlspecialchars((string)($plan['limit_notas'] ?? '0')) ?>" required>
  </div>
  <div class="col-md-3">
    <label class="form-label">Preço (R$)</label>
    <input class="form-control" type="number" step="0.01" name="price" value="<?= htmlspecialchars((string)($plan['price'] ?? '0')) ?>" required>
  </div>
  <div class="col-md-12">
    <label class="form-label">Permissões</label>
    <input class="form-control" type="text" name="features" value="<?= htmlspecialchars($plan['features'] ?? '') ?>" placeholder="consulta,download,manifestacao,relatorios">
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Salvar</button>
    <a class="btn btn-secondary" href="/admin/plans">Voltar</a>
  </div>
  </form>
</div>
</body>
</html>
