<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Admin - Nova Empresa</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4">Cadastrar nova empresa</h1>
        <div>
            <a href="/admin/empresas" class="btn btn-secondary">Empresas</a>
        </div>
    </div>
    <form method="post" action="/admin/empresa/salvar" class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Nome</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">Razão Social</label>
            <input type="text" name="razao_social" class="form-control">
        </div>
        <div class="col-md-4">
            <label class="form-label">CNPJ</label>
            <input type="text" name="cnpj" class="form-control" required>
        </div>
        <div class="col-md-2">
            <label class="form-label">UF</label>
            <select name="uf" class="form-select" required>
                <?php foreach (['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'] as $u): ?>
                    <option value="<?= $u ?>"><?= $u ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Ambiente</label>
            <select name="ambiente" class="form-select" required>
                <option value="homologacao">Homologação</option>
                <option value="producao">Produção</option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Plano</label>
            <select name="plan_id" class="form-select" required>
                <?php foreach ($plans as $p): ?>
                    <option value="<?= htmlspecialchars((string)$p['id']) ?>"><?= htmlspecialchars($p['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label">Email do administrador</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">Senha do administrador</label>
            <input type="password" name="senha" class="form-control" required>
        </div>
        <div class="col-12">
            <button class="btn btn-primary">Salvar</button>
        </div>
    </form>
</body>
</html>
