<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Admin - Assinaturas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<nav class="navbar navbar-expand-lg navbar-light bg-white border rounded px-3 mb-3">
  <a class="navbar-brand" href="/admin">Admin Master</a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAdmin"><span class="navbar-toggler-icon"></span></button>
  <div class="collapse navbar-collapse" id="navAdmin">
    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/admin">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/empresas">Empresas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/plans">Planos</a></li>
      <li class="nav-item"><a class="nav-link active" href="/admin/assinaturas">Assinaturas</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/pagamentos">Pagamentos</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/webhooks">Webhooks</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/sefaz">Logs SEFAZ</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/login">Logs Login</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/admin">Logs Admin</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/logs/erro">Logs Erro</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/usuarios">Usuários</a></li>
      <li class="nav-item"><a class="nav-link" href="/admin/config">Configurações</a></li>
    </ul>
    <div class="d-flex align-items-center gap-2">
      <span class="badge bg-primary">Admin</span>
      <a class="btn btn-outline-secondary btn-sm" href="/logout">Sair</a>
    </div>
  </div>
</nav>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4">Assinaturas</h1>
</div>
<table class="table table-striped table-sm">
  <thead><tr><th>ID</th><th>Empresa</th><th>Plano</th><th>Status</th><th>Início</th><th>Fim</th><th>Ações</th></tr></thead>
  <tbody>
    <?php foreach ($assinaturas as $a): ?>
    <tr>
      <td><?= (int)$a['id'] ?></td>
      <td><?= htmlspecialchars($a['empresa'] ?? '') ?></td>
      <td><?= htmlspecialchars($a['plano'] ?? '') ?></td>
      <td><span class="badge bg-<?= ($a['status']==='ativa')?'success':(($a['status']==='cancelada')?'danger':'secondary') ?>"><?= htmlspecialchars($a['status'] ?? '') ?></span></td>
      <td><?= htmlspecialchars($a['data_inicio'] ?? '') ?></td>
      <td><?= htmlspecialchars($a['data_fim'] ?? '') ?></td>
      <td class="d-flex gap-2">
        <form method="post" action="/admin/assinatura/renovar">
          <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
          <button class="btn btn-sm btn-outline-primary">Renovar +1 mês</button>
        </form>
        <form method="post" action="/admin/assinatura/cancelar">
          <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
          <button class="btn btn-sm btn-outline-danger">Cancelar</button>
        </form>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
</body>
</html>
