<?php
use App\Core\Router;
use App\Controllers\AuthController;
use App\Controllers\DashboardController;
use App\Controllers\TenantController;
use App\Controllers\SefazController;
use App\Controllers\PaymentController;
use App\Controllers\ReportController;
use App\Controllers\CronController;
use App\Controllers\SubscriptionController;
use App\Controllers\ReprocessController;
use App\Controllers\NotasController;
use App\Middleware\AuthMiddleware;
use App\Middleware\PlanMiddleware;
use App\Controllers\AdminController;
use App\Middleware\AdminMiddleware;

/** @var Router $router */
$router->get('/', [AuthController::class, 'showLogin']);
$router->get('/login', [AuthController::class, 'showLogin']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/register', [AuthController::class, 'showRegister']);
$router->post('/register', [AuthController::class, 'register']);
$router->get('/logout', [AuthController::class, 'logout'], [AuthMiddleware::class]);
$router->get('/perfil', [AuthController::class, 'showProfile'], [AuthMiddleware::class]);
$router->post('/perfil/salvar', [AuthController::class, 'profileSave'], [AuthMiddleware::class]);
$router->post('/perfil/senha', [AuthController::class, 'profilePassword'], [AuthMiddleware::class]);

$router->get('/dashboard', [DashboardController::class, 'index'], [AuthMiddleware::class, PlanMiddleware::class]);

$router->get('/tenant', [TenantController::class, 'form'], [AuthMiddleware::class]);
$router->post('/tenant/save', [TenantController::class, 'save'], [AuthMiddleware::class]);
$router->get('/tenant/check-cert', [TenantController::class, 'checkCert'], [AuthMiddleware::class]);

$router->get('/sefaz/teste', [SefazController::class, 'teste'], [AuthMiddleware::class, PlanMiddleware::class]);
$router->get('/sefaz/consultar', [SefazController::class, 'consultar'], [AuthMiddleware::class, PlanMiddleware::class]);

$router->get('/painel', [NotasController::class, 'painel'], [AuthMiddleware::class]);
$router->get('/xml/ver', [NotasController::class, 'verXml'], [AuthMiddleware::class]);
$router->get('/xml/download', [NotasController::class, 'downloadXml'], [AuthMiddleware::class]);

$router->post('/webhook/mercadopago', [PaymentController::class, 'webhook']);

$router->get('/relatorios/pdf', [ReportController::class, 'pdf'], [AuthMiddleware::class]);
$router->get('/relatorios/csv', [ReportController::class, 'csv'], [AuthMiddleware::class]);

$router->get('/cron/consulta', [CronController::class, 'runConsulta']);
$router->get('/cron/manifestacao', [CronController::class, 'runManifestacao']);
$router->get('/cron/reprocessar', [ReprocessController::class, 'run']);
$router->get('/cron/manifestacao/notas', [CronController::class, 'runManifestacaoNotas']);

$router->get('/plano/assinatura', [SubscriptionController::class, 'show'], [AuthMiddleware::class]);
$router->post('/plano/assinatura/criar', [SubscriptionController::class, 'create'], [AuthMiddleware::class]);
$router->get('/plano/status', [SubscriptionController::class, 'status'], [AuthMiddleware::class]);

$router->get('/admin/empresas', [AdminController::class, 'empresas'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/pagamentos', [AdminController::class, 'pagamentos'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/empresa/status', [AdminController::class, 'alterarStatus'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/empresa/trocar-senha', [AdminController::class, 'trocarSenha'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/empresa/nova', [AdminController::class, 'nova'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/empresa/salvar', [AdminController::class, 'salvar'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin', [AdminController::class, 'dashboard'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/plans', [AdminController::class, 'plans'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/plan/form', [AdminController::class, 'planForm'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/plan/save', [AdminController::class, 'planSave'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/plan/delete', [AdminController::class, 'planDelete'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/assinaturas', [AdminController::class, 'assinaturas'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/assinatura/renovar', [AdminController::class, 'assinaturaRenovar'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/assinatura/cancelar', [AdminController::class, 'assinaturaCancelar'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/webhooks', [AdminController::class, 'webhooks'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/logs/sefaz', [AdminController::class, 'logsSefaz'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/logs/erro', [AdminController::class, 'logsErro'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/logs/login', [AdminController::class, 'logsLogin'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/logs/admin', [AdminController::class, 'logsAdmin'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/usuarios', [AdminController::class, 'usuarios'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/usuario/role', [AdminController::class, 'usuarioRoleSalvar'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/empresa/usuarios', [AdminController::class, 'empresaUsuarios'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/empresa/usuario/salvar', [AdminController::class, 'empresaUsuarioSalvar'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/empresa/usuario/senha', [AdminController::class, 'empresaUsuarioSenha'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->get('/admin/config', [AdminController::class, 'configuracoes'], [AuthMiddleware::class, AdminMiddleware::class]);
$router->post('/admin/config/salvar', [AdminController::class, 'configuracoesSalvar'], [AuthMiddleware::class, AdminMiddleware::class]);
